package contentadmin

import (
	"time"

	"github.com/cenkalti/backoff/v4"
)

func getBackOffPolicy() backoff.BackOff {
	return &backoff.ExponentialBackOff{
		InitialInterval:     100 * time.Millisecond,
		RandomizationFactor: backoff.DefaultRandomizationFactor,
		Multiplier:          backoff.DefaultMultiplier,
		MaxInterval:         600 * time.Millisecond,
		MaxElapsedTime:      2 * time.Second,
		Clock:               backoff.SystemClock,
		Stop:                backoff.Stop,
	}
}
