package services

import (
	"context"

	"a.yandex-team.ru/travel/komod/trips/api/processor/v1"
	"a.yandex-team.ru/travel/komod/trips/internal/orders"
)

type Processor interface {
	Process(ctx context.Context, req *processor.ProcessTripEntityReq) error
}

type UnprocessedOrders interface {
	Put(ctx context.Context, message *processor.ProcessTripEntityReq) error
	PutOrderID(ctx context.Context, orderID orders.ID, retriesCount uint32) error
	StoreFailed(ctx context.Context, message *processor.ProcessTripEntityReq) error
}
