package processor

import "time"

type Config struct {
	Timeout    time.Duration `config:"TRIPS_PROCESSOR_TIMEOUT"`
	YPlannerID string        `config:"TRIPS_PROCESSOR_Y_PLANNER_ID" yaml:"y_planner_id"`
	TvmID      uint32        `config:"TRIPS_PROCESSOR_TVM_ID" yaml:"tvm_id"`
	RPSLimit   float32       `config:"TRIPS_PROCESSOR_RPS_LIMIT" yaml:"rps_limit"`
}

var DefaultConfig = Config{
	Timeout:    15 * time.Second,
	YPlannerID: "travel-trips-testing.processor",
	RPSLimit:   10,
}
