package weather

import "time"

type HTTPClientConfig struct {
	TravelAPIHost  string        `yaml:"travel_api_host"`
	TravelAPITvmID uint32        `yaml:"travel_api_tvm_id"`
	RequestTimeout time.Duration `yaml:"request_timeout"`
}

var DefaultHTTPClientConfig = HTTPClientConfig{
	TravelAPIHost:  "https://api.travel-balancer-test.yandex.net",
	TravelAPITvmID: 2002548,
	RequestTimeout: 700 * time.Millisecond,
}
