package weather

type GetByGeoIDResponse struct {
	Data struct {
		Items []*GetByGeoIDResponseItem `json:"items"`
	} `json:"data"`
}

type GetByGeoIDResponseItem struct {
	ImageURL    string   `json:"image_url"`
	Title       string   `json:"title"`
	Description string   `json:"description"`
	URL         string   `json:"url"`
	ItemType    ItemType `json:"item_type"`
}

type ItemType string

const (
	ForecastItemType ItemType = "FORECAST"
	ClimateItemType  ItemType = "CLIMATE"
)
