package sharedflights

type Flight struct {
	AirlineIata       string    `json:"airlineIata"`
	AirlineID         int       `json:"airlineID"`
	Number            string    `json:"number"`
	AirportFromCode   string    `json:"airportFromCode"`
	AirportFromID     int       `json:"airportFromId"`
	DepartureDay      string    `json:"departureDay"`
	DepartureTime     string    `json:"departureTime"`
	DepartureTimezone string    `json:"departureTimezone"`
	DepartureUTC      string    `json:"departureUtc"`
	DepartureTerminal string    `json:"departureTerminal"`
	AirportToCode     string    `json:"airportToCode"`
	AirportToID       int       `json:"airportToId"`
	ArrivalDay        string    `json:"arrivalDay"`
	ArrivalTime       string    `json:"arrivalTime"`
	ArrivalTimezone   string    `json:"arrivalTimezone"`
	ArrivalUTC        string    `json:"arrivalUtc"`
	ArrivalTerminal   string    `json:"arrivalTerminal"`
	CreatedAtUTC      string    `json:"createdAtUtc"`
	UpdatedAtUTC      string    `json:"updatedAtUtc"`
	Status            Status    `json:"status"`
	Segments          []*Flight `json:"segments"`
	Title             string    `json:"title"`
}

type Status struct {
	Status                string  `json:"status"`
	Departure             string  `json:"departure"`
	Arrival               string  `json:"arrival"`
	DepartureStatus       string  `json:"departureStatus"`
	ArrivalStatus         string  `json:"arrivalStatus"`
	ArrivalGate           string  `json:"arrivalGate"`
	ArrivalTerminal       string  `json:"arrivalTerminal"`
	DepartureGate         string  `json:"departureGate"`
	DepartureTerminal     string  `json:"departureTerminal"`
	DepartureSource       string  `json:"departureSource"`
	ArrivalSource         string  `json:"arrivalSource"`
	CheckInDesks          string  `json:"checkInDesks"`
	BaggageCarousels      string  `json:"baggageCarousels"`
	CreatedAtUTC          string  `json:"createdAtUtc"`
	UpdatedAtUTC          string  `json:"updatedAtUtc"`
	DepartureUpdatedAtUTC string  `json:"departureUpdatedAtUtc"`
	ArrivalUpdatedAtUTC   string  `json:"arrivalUpdatedAtUtc"`
	Diverted              bool    `json:"diverted"`
	DivertedAirportIata   *string `json:"divertedAirportIata"`
	DivertedAirportID     int     `json:"divertedAirportID"`
}
