package span

import (
	"a.yandex-team.ru/travel/komod/trips/internal/models"
	"a.yandex-team.ru/travel/komod/trips/internal/point"
)

type SpanComparator struct {
	pointComparator *point.Comparator
}

func NewSpanComparator(pointComparator *point.Comparator) *SpanComparator {
	return &SpanComparator{pointComparator: pointComparator}
}

func (c *SpanComparator) Compare(lhs, rhs models.Span) bool {
	return c.SameSpans(lhs, rhs)
}

func (c *SpanComparator) CompareSlices(lhs, rhs []models.Span) bool {
	if len(lhs) != len(rhs) {
		return false
	}
	for i, leftSpan := range lhs {
		if !c.Compare(leftSpan, rhs[i]) {
			return false
		}
	}
	return true
}

func (c *SpanComparator) SameSpans(spanA, spanB models.Span) bool {
	return c.SameVisits(spanA.Start(), spanB.Start()) && c.SameVisits(spanA.End(), spanB.End())
}

func (c *SpanComparator) SameVisits(visitA, visitB models.Visit) bool {
	return c.pointComparator.SamePoints(visitA.Point(), visitB.Point()) && visitA.When().Equal(visitB.When())
}
