package span

import (
	"time"

	"a.yandex-team.ru/travel/komod/trips/internal/models"
)

// DatesIntersect
// (l1----[l2----r1)----r2] or [l2----(l1----r2]----r1)
// all inequalities are strict
func DatesIntersect(l models.Span, r models.Span) bool {
	return DateInSpan(l.Start().When(), r) || DateInSpan(l.End().When(), r)
}

// DateInSpan
// [l <= when <= r]
func DateInSpan(when time.Time, interval models.Span) bool {
	spanStart := TruncateToDate(interval.Start().When())
	spanEnd := TruncateToDate(interval.End().When())
	when = TruncateToDate(when)
	return !when.Before(spanStart) && !when.After(spanEnd)
}

func TruncateToDate(dt time.Time) time.Time {
	year, month, day := dt.Date()
	return time.Date(year, month, day, 0, 0, 0, 0, dt.Location())
}

// IsSuperSpan
// (l1----[l2----r2]----r1)
// all inequalities are strict
func IsSuperSpan(superSpan models.Span, subSpan models.Span) bool {
	return !subSpan.Start().When().Before(superSpan.Start().When()) && !subSpan.End().When().After(superSpan.End().When())
}

func GetStartVisit(spans []models.Span) models.Visit {
	if len(spans) == 0 {
		return models.Visit{}
	}
	visits := ExtractVisitsFromSpans(spans)
	start := visits[0]
	for _, v := range visits[1:] {
		if start.When().After(v.When()) {
			start = v
		}
	}
	return start
}

func GetStartTime(spans []models.Span) time.Time {
	return GetStartVisit(spans).When()
}

func GetEndVisit(spans []models.Span) models.Visit {
	if len(spans) == 0 {
		return models.Visit{}
	}
	visits := ExtractVisitsFromSpans(spans)
	end := visits[0]
	for _, v := range visits[1:] {
		if end.When().Before(v.When()) {
			end = v
		}
	}
	return end
}

func GetEndTime(spans []models.Span) time.Time {
	return GetEndVisit(spans).When()
}

func ExtractVisitsFromSpans(spans []models.Span) []models.Visit {
	var visits []models.Visit
	for _, t := range spans {
		visits = append(visits, t.Start(), t.End())
	}
	return visits
}
