package trips

import (
	"context"

	"a.yandex-team.ru/travel/komod/trips/internal/models"
	tripmodels "a.yandex-team.ru/travel/komod/trips/internal/trips/models"
)

type Matcher interface {
	MatchTripsWithConnectedSpans(tripmodels.Trips, ...models.Span) tripmodels.Trips
}

type StorageSession interface {
	GetTrips(ctx context.Context, passportID string) (tripmodels.Trips, error)
	GetTrip(ctx context.Context, tripID string) (*tripmodels.Trip, error)
}

type StorageTxSession interface {
	StorageSession
	LockUser(ctx context.Context, passportID string) error
	RemoveTripOrderSpans(ctx context.Context, tripID string) error
	RemoveTrips(ctx context.Context, items ...*tripmodels.Trip) error
	UpsertTrips(ctx context.Context, items ...*tripmodels.Trip) error
}

type Storage interface {
	GetSession() StorageSession
	ExecuteInTransaction(txBody func(tx StorageTxSession) error) error
}
