package matcher

import (
	"a.yandex-team.ru/travel/komod/trips/internal/models"
	tripsmodels "a.yandex-team.ru/travel/komod/trips/internal/trips/models"
)

type Matcher struct {
	rule   Rule
	config Config
}

func NewMatcher(rule Rule, config Config) *Matcher {
	return &Matcher{rule: rule, config: config}
}

func (m *Matcher) MatchTripsWithConnectedSpans(currentTrips tripsmodels.Trips, spans ...models.Span) tripsmodels.Trips {
	needMerge := make(map[string]bool)

	for _, span := range spans {
		for _, trip := range currentTrips {
			if m.config.Testing.Enabled && len(trip.OrderInfos) >= m.config.Testing.MaxOrdersInTrip {
				continue
			}
			needMerge[trip.ID] = needMerge[trip.ID] || m.needMerge(span, trip)
		}
	}

	var result tripsmodels.Trips
	for _, trip := range currentTrips {
		if needMerge[trip.ID] {
			result = append(result, trip)
		}
	}
	return result
}

func (m Matcher) needMerge(span models.Span, trip *tripsmodels.Trip) bool {
	if m.rule.NeedMerge(span, asSpan(trip)) {
		return true
	}
	for _, tripSpan := range trip.GetSpans() {
		if m.rule.NeedMerge(span, tripSpan) {
			return true
		}
	}
	return false
}
