package matcher

import (
	"a.yandex-team.ru/travel/komod/trips/internal/models"
)

type Rule interface {
	NeedMerge(lhs, rhs models.Span) bool
}

type OrRule struct {
	rules []Rule
}

func NewOrRule(rules ...Rule) *OrRule {
	return &OrRule{rules: rules}
}

func (r OrRule) NeedMerge(lhs, rhs models.Span) bool {
	for _, rule := range r.rules {
		if rule.NeedMerge(lhs, rhs) {
			return true
		}
	}
	return false
}

type Predicate func(lhs, rhs models.Span) bool

type PredicateRule struct {
	predicate Predicate
}

func NewPredicateRule(predicate func(lhs, rhs models.Span) bool) *PredicateRule {
	return &PredicateRule{predicate: predicate}
}

func (r PredicateRule) NeedMerge(lhs, rhs models.Span) bool {
	return r.predicate(lhs, rhs)
}

type WholeTripRule struct {
	nested Rule
}

func NewWholeTripRule(nested Rule) *WholeTripRule {
	return &WholeTripRule{nested: nested}
}

func (r WholeTripRule) NeedMerge(lhs, rhs models.Span) bool {
	if isLongerTripThanPopular(lhs, rhs) {
		return false
	}
	_, leftOk := lhs.(spanTrip)
	_, rightOk := rhs.(spanTrip)
	if leftOk || rightOk {
		return r.nested.NeedMerge(lhs, rhs)
	}
	return false
}
