package matcher

import (
	"time"

	"a.yandex-team.ru/travel/komod/trips/internal/models"
	tripsmodels "a.yandex-team.ru/travel/komod/trips/internal/trips/models"
)

func asSpan(trip *tripsmodels.Trip) spanTrip {
	spans := trip.GetSpans()
	first := spans[0]
	isTransport := false
	for _, s := range trip.GetSpans() {
		if s.Start().When().Before(first.Start().When()) {
			first = s
		}
		isTransport = isTransport || s.IsTransport()
	}

	last := spans[0]
	for _, s := range spans[1:] {
		if s.End().When().After(last.End().When()) {
			last = s
		}
	}
	return spanTrip{
		first:       first,
		last:        last,
		isTransport: isTransport,
		duration:    last.End().When().Sub(first.Start().When()),
	}
}

type spanTrip struct {
	first, last models.Span
	isTransport bool
	duration    time.Duration
}

func (a spanTrip) Start() models.Visit {
	return a.first.Start()
}

func (a spanTrip) End() models.Visit {
	return a.last.End()
}

func (a spanTrip) IsTransport() bool {
	return a.isTransport
}

func (a spanTrip) Duration() time.Duration {
	return a.duration
}
