package unifiedagent

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/metrics"
	uaclient "a.yandex-team.ru/library/go/yandex/uagent/log/zap/client"
	"a.yandex-team.ru/logbroker/unified_agent/client/go/ua"
)

type mockClient struct {
}

func newMockClient() *mockClient {
	return &mockClient{}
}

func (m *mockClient) Send(clientMessages []uaclient.Message) error {
	return nil
}

func (m *mockClient) Stat() uaclient.Stats {
	return &ua.Stat{}
}

func (m *mockClient) GRPCMaxMessageSize() int64 {
	return 0
}

func (m *mockClient) CollectMetrics(r metrics.Registry, c metrics.CollectPolicy) {
}

func (m *mockClient) Close(ctx context.Context) error {
	return nil
}

func NewClient(config Config, ctx context.Context, logger log.Logger) (uaclient.Client, error) {
	if config.Enabled {
		return ua.NewClient(ctx, config.Address, ua.WithLogger(logger))
	}
	return newMockClient(), nil
}
