package usercredentials

import "context"

var contextKey = &struct{}{}

func NewContext(ctx context.Context, uc UserCredentials) context.Context {
	return context.WithValue(ctx, contextKey, uc)
}

func FromContext(ctx context.Context) UserCredentials {
	uc, ok := ctx.Value(contextKey).(UserCredentials)
	if ok {
		return uc
	}
	return make(UserCredentials)
}
