package usercredentials

import (
	"context"

	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
)

func NewUnpackInterceptor() grpc.UnaryServerInterceptor {
	return func(ctx context.Context, req interface{}, info *grpc.UnaryServerInfo, handler grpc.UnaryHandler) (interface{}, error) {
		credentials := fromIncomingContext(ctx)
		resp, err := handler(
			NewContext(ctx, credentials),
			req,
		)
		return resp, err
	}
}

func fromIncomingContext(ctx context.Context) UserCredentials {
	credentials := make(UserCredentials)
	meta, ok := metadata.FromIncomingContext(ctx)
	if !ok {
		return credentials
	}
	for _, key := range keys {
		if len(meta.Get(key)) != 0 {
			credentials[key] = meta[key][0]
		}
	}
	return credentials
}
