package usercredentials

type UserCredential = string

const (
	UserCredentialYandexUID  UserCredential = "x-ya-yandexuid"
	UserCredentialPassportID UserCredential = "x-ya-passportid"
	UserCredentialUserTicket UserCredential = "x-ya-user-ticket"
)

var keys = []UserCredential{UserCredentialYandexUID, UserCredentialPassportID, UserCredentialUserTicket}

type UserCredentials map[UserCredential]string

func (uc UserCredentials) UserTicket() (string, bool) {
	res, ok := uc[UserCredentialUserTicket]
	return res, ok
}

func (uc UserCredentials) YandexUID() (string, bool) {
	res, ok := uc[UserCredentialYandexUID]
	return res, ok
}

func (uc UserCredentials) PassportID() (string, bool) {
	res, ok := uc[UserCredentialPassportID]
	return res, ok
}
