#!/usr/bin/env bash
case $- in
    *x*) restore_x_setting() {
            set -x
         };;
      *) restore_x_setting() {
            set +x
         };;
esac
set +x

get_secret(){
   ya vault get version $1 --json | ya tool jq .value.$2 | tr -d '"'
}

# секрет нашего TVM приложения
# https://yav.yandex-team.ru/secret/sec-01fp7ks6envz07xxaqgx3pxhv2
export TRIPS_API_BACKEND_TVM_SECRET="$(get_secret sec-01fp7ks6envz07xxaqgx3pxhv2 client_secret)"

export LOGBROKER_PRODUCER_TOKEN="$(get_secret sec-01e487k510yycfs1h6bepjsx07 token)"

# порт на котором будет поднят TVM демон
export LOCAL_TVM_PORT=9005

# URL на котором будет поднят TVM демон
export DEPLOY_TVM_TOOL_URL=http://localhost:${LOCAL_TVM_PORT}

# путь до конфига нашего приложения в dev
export CONFIG_PATH=./dev/api.config.yaml

# произвольные 32 символа, должны быть одинаковыми для поднятого TVM-демона и нашего приложения
export TVMTOOL_LOCAL_AUTHTOKEN="dev-tvm-auth-token-number-000001"
# curl 'http://127.0.0.1:9005/tvm/tickets?dsts=travel-api' -H 'Authorization: dev-tvm-auth-token-number-000001'

restore_x_setting
