# coding: utf8

import os
import json

import requests


JUGGLER_URL = 'http://juggler-push.search.yandex.net/events'
JUGGLER_TIMEOUT = 5


class JugglerCheckSender:
    def __init__(
        self, check_name, source, host, tags=None, jugger_url=JUGGLER_URL, jugger_timeout=JUGGLER_TIMEOUT
    ):
        self.tags = tags or []
        self.check_name = check_name
        self.source = source
        self.host = host
        self.jugger_url = jugger_url
        self.jugger_timeout = jugger_timeout

    def send_event(self, status, description):
        if status not in ('OK', 'CRIT', 'WARN'):
            raise ValueError('Bad status. Expected OK, CRIT or WARN.')

        data = {
            'source': self.source,
            'events': [
                {
                    'description': description,
                    'host': self.host,
                    'instance': '',
                    'service': self.check_name,
                    'status': status,
                    'tags': self.tags,
                }
            ],
        }

        requests.post(self.jugger_url, data=json.dumps(data), timeout=self.jugger_timeout)


def make_deploy_check_sender(check_name, tags=None):
    source = '{}.{}.{}.{}'.format(
        os.getenv('TRAVEL_DEPLOY_PROJECT'),
        os.getenv('TRAVEL_DEPLOY_APPLICATION'),
        os.getenv('TRAVEL_DEPLOY_ENVIRONMENT'),
        os.getenv('TRAVEL_DEPLOY_UNIT'),
    )
    host = os.getenv('TRAVEL_DEPLOY_HOST')
    return JugglerCheckSender(check_name, source=source, host=host, tags=tags)
