# coding: utf-8
from __future__ import absolute_import, division, print_function
import json

PROJECT = 'rasp'
APPLICATION = '{MY-APPLICATION-NAME}'
ENVIRONMENT = 'production'
COMPONENT = 'main'
BALANCER = '{MYBALANCER}.rasp.yandex.ru'.replace('.', '_')

DCS = ['man', 'iva', 'sas']
PERCENTILES = ['75', '90', '95', '99']
ERROR_TYPES = ['maps_404_rps', 'maps_400_rps', 'maps_errors_rps']
dashboard_content = [
    {
        'target': [
            'cluster.geo.{project}.qloud-ext_{project}_{application}_{environment}_{component}.'
            '{balancer}-{dc}.maps_ok_rps.rps'.format(
                project=PROJECT, application=APPLICATION, environment=ENVIRONMENT, component=COMPONENT, dc=dc,
                balancer=BALANCER
            ) for dc in DCS
        ],
        'hideLegend': False,
        'areaMode': 'stacked',
        'title': 'ok rps, container nginx',
        'height': '400',
        'width': '690',
        '_salt': '1523967151.224'
    },
    {
        'target': [
            'cluster.geo.{project}.qloud-ext_{project}_{application}_{environment}_{component}.'
            'TOTAL.maps_ok_upstream_timings.{perc}_prc'.format(
                project=PROJECT, application=APPLICATION, environment=ENVIRONMENT, component=COMPONENT, perc=perc
            ) for perc in PERCENTILES
        ],
        'hideLegend': False,
        'title': 'timings, container nginx',
        'height': '403',
        'width': '575',
        '_salt': '1523968244.232'
    },
    {
        'target': [
            'cluster.geo.{project}.qloud-ext_{project}_{application}_{environment}_{component}.'
            'TOTAL.{err}.rps'.format(
                project=PROJECT, application=APPLICATION, environment=ENVIRONMENT, component=COMPONENT, err=err
            ) for err in ERROR_TYPES
        ],
        'width': '575',
        'title': 'errors, container nginx',
        'height': '403',
        'hideLegend': 'false',
        '_salt': '1523968669.613'
    },
    {
        'target': [
            'cluster.geo.{project}.qloud-ext_{project}_{application}_{environment}_{component}.'
            '{balancer}-{dc}.maps_ok_upstream_timings.90_prc'.format(
                project=PROJECT, application=APPLICATION, environment=ENVIRONMENT, component=COMPONENT, dc=dc,
                balancer=BALANCER
            ) for dc in DCS
        ],
        'width': '575',
        'title': 'timings by dc, container nginx',
        'height': '403',
        'hideLegend': 'false',
        '_salt': '1523969019.388'
    }
]

print(json.dumps(dashboard_content, indent=2))
