# coding: utf8
import os

from setuptools import setup

# read requirements
fname = os.path.join(os.path.dirname(__file__), 'requirements.txt')
with open(fname) as f:
    requirements = [l.strip() for l in f.readlines()]

setup(
    name='unistat_aggregator',
    version='0.1.8',
    author='Lev Orekhov',
    author_email='lorekhov@yandex-team.ru',
    python_requires='>=3.6',
    packages=['unistat_aggregator'],
    install_requires=requirements,
    entry_points={
        'console_scripts': ['unistat_aggregator = unistat_aggregator.app:run']
    },
)
