package containers

import (
	"encoding/json"
)

var empty = struct{}{}

type Set[V comparable] map[V]struct{}

func SetOf[V comparable](elements ...V) Set[V] {
	set := make(Set[V], len(elements))
	for _, e := range elements {
		set[e] = empty
	}
	return set
}

func (set Set[V]) Contains(value V) bool {
	_, ok := set[value]
	return ok
}

func (set Set[V]) Add(value V) {
	set[value] = empty
}

func (set Set[V]) Remove(value V) {
	delete(set, value)
}

func (set Set[V]) Values() []V {
	values := make([]V, 0, len(set))
	for value := range set {
		values = append(values, value)
	}
	return values
}

func (set *Set[V]) UnmarshalJSON(data []byte) error {
	var values []V
	if err := json.Unmarshal(data, &values); err != nil {
		return err
	}
	*set = SetOf(values...)
	return nil
}

func (set Set[V]) MarshalJSON() ([]byte, error) {
	return json.Marshal(set.Values())
}
