package containers

func CountIf[T any](values []T, predicate func(T) bool) int {
	count := 0
	for _, value := range values {
		if predicate(value) {
			count++
		}
	}
	return count
}

func FilterBy[T any](values []T, predicate func(T) bool) []T {
	result := make([]T, 0)
	for _, value := range values {
		if predicate(value) {
			result = append(result, value)
		}
	}
	return result
}

func IterateByWindow[T any](values []T, windowSize int) [][]T {
	result := make([][]T, 0)
	if windowSize < 1 || windowSize > len(values) {
		return result
	}

	for i := 0; i < len(values)-windowSize+1; i++ {
		result = append(result, values[i:i+windowSize])
	}
	return result
}
