package cron

import (
	"context"

	"github.com/jasonlvhit/gocron"
)

// Adds an option to stop scheduler by cancelling the context to the gocron scheduler
type Scheduler struct {
	*gocron.Scheduler
	context context.Context
	stopper chan bool
}

func NewScheduler(ctx context.Context, scheduler *gocron.Scheduler) *Scheduler {
	s := &Scheduler{Scheduler: scheduler, context: ctx}
	go s.waitContextCancellation()
	return s
}

func (s *Scheduler) waitContextCancellation() {
	<-s.context.Done()
	if s.stopper != nil {
		s.stopper <- true
	}
}

func (s *Scheduler) Start() {
	s.stopper = s.Scheduler.Start()
}
