package localexts

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type SettlementsByCountryID struct {
	byCountryID map[int32][]*rasp.TSettlement
}

func NewSettlementsByCountryID() *SettlementsByCountryID {
	return &SettlementsByCountryID{
		byCountryID: make(map[int32][]*rasp.TSettlement),
	}
}

func (ext *SettlementsByCountryID) AddProto(message proto.Message) {
	settlement := message.(*rasp.TSettlement)
	if settlement.CountryId != 0 {
		ext.byCountryID[settlement.CountryId] = append(ext.byCountryID[settlement.CountryId], settlement)
	}
}

func (ext *SettlementsByCountryID) GetByCountryID(id int) ([]*rasp.TSettlement, bool) {
	settlement, ok := ext.byCountryID[int32(id)]
	return settlement, ok
}
