package main

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/examples/custom_repository/localexts"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	rpb "a.yandex-team.ru/travel/proto/dicts/rasp"
)

type ExampleRepo struct {
	*base.Repository
	*extensions.SettlementByID
	*extensions.SettlementByGeoID
	*localexts.SettlementsByCountryID
}

func NewExampleRepo() *ExampleRepo {
	newProto := func() proto.Message {
		return &rpb.TSettlement{}
	}

	repo := &ExampleRepo{
		Repository:             base.NewRepository("example", newProto),
		SettlementByID:         extensions.NewSettlementByID(),
		SettlementByGeoID:      extensions.NewSettlementByGeoID(),
		SettlementsByCountryID: localexts.NewSettlementsByCountryID(),
	}
	repo.AddExtensions(
		repo.SettlementByID,
		repo.SettlementByGeoID,
		repo.SettlementsByCountryID,
	)
	return repo
}

func main() {
	repo := NewExampleRepo()

	object1 := &rpb.TSettlement{Id: 1, GeoId: 1, CountryId: 1}
	object2 := &rpb.TSettlement{Id: 2, CountryId: 2}
	object3 := &rpb.TSettlement{Id: 3, GeoId: 2, CountryId: 1}

	repo.Add(object1)
	repo.Add(object2)
	repo.Add(object3)

	actual, _ := repo.Get(2)
	fmt.Printf("repo.Get(2) return object2: %t\n", actual == object2)

	actual, _ = repo.GetByGeoID(2)
	fmt.Printf("repo.GetByGeoID(2) return object3: %t\n", actual == object3)

	actualObjects, _ := repo.GetByCountryID(1)
	fmt.Printf(
		"repo.GetByCountryID(1) return [object1, object3]: %t\n",
		len(actualObjects) == 2 &&
			actualObjects[0] == object1 &&
			actualObjects[1] == object3,
	)
}
