package main

import (
	"flag"
	"fmt"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/repository"
)

func main() {
	var path string
	flag.StringVar(&path, "path", "settlement.data", "path to file with settlemets")

	bytesIterator, err := base.BuildIteratorFromFile(path)
	if err != nil {
		fmt.Printf("Error while creating iterator %v\n", err)
		fmt.Printf("Please ensure thats file with data is in place: %s\n", path)
	}

	settlementRepo := repository.NewSettlementRepository()
	err = bytesIterator.Populate(settlementRepo)
	if err != nil {
		fmt.Printf("Error while populating repository %v", err)
	}

	res, found := settlementRepo.Get(213)
	if !found {
		fmt.Print("Something goes wrong, no Moscow :(")
	}

	fmt.Printf("Moscow is %+v", res)
}
