package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type CountryByID struct {
	byID map[int32]*rasp.TCountry
}

func NewCountryByID() *CountryByID {
	return &CountryByID{
		byID: make(map[int32]*rasp.TCountry),
	}
}

func (ext *CountryByID) AddProto(message proto.Message) {
	country := message.(*rasp.TCountry)
	if country.Id != 0 {
		ext.byID[country.Id] = country
	}
}

func (ext *CountryByID) Get(id int32) (*rasp.TCountry, bool) {
	country, ok := ext.byID[id]
	return country, ok
}

type CountryByGeoID struct {
	byGeoID map[int32]*rasp.TCountry
}

func NewCountryByGeoID() *CountryByGeoID {
	return &CountryByGeoID{
		byGeoID: make(map[int32]*rasp.TCountry),
	}
}

func (m *CountryByGeoID) AddProto(message proto.Message) {
	country := message.(*rasp.TCountry)
	if country.GeoId != 0 {
		m.byGeoID[country.GeoId] = country
	}
}

func (m *CountryByGeoID) GetByGeoID(geoID int32) (*rasp.TCountry, bool) {
	country, ok := m.byGeoID[geoID]
	return country, ok
}
