package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type CurrencyByID struct {
	byID map[int32]*rasp.TCurrency
}

func NewCurrencyByID() *CurrencyByID {
	return &CurrencyByID{
		byID: make(map[int32]*rasp.TCurrency),
	}
}

func (ext *CurrencyByID) AddProto(message proto.Message) {
	currency := message.(*rasp.TCurrency)
	if currency.Id != 0 {
		ext.byID[currency.Id] = currency
	}
}

func (ext *CurrencyByID) Get(id int32) (*rasp.TCurrency, bool) {
	currency, ok := ext.byID[id]
	return currency, ok
}
