package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type RegionByID struct {
	byID map[uint32]*rasp.TRegion
}

func NewRegionByID() *RegionByID {
	return &RegionByID{
		byID: make(map[uint32]*rasp.TRegion),
	}
}

func (ext *RegionByID) AddProto(message proto.Message) {
	region := message.(*rasp.TRegion)
	if region.Id != 0 {
		ext.byID[region.Id] = region
	}
}

func (ext *RegionByID) Get(id uint32) (*rasp.TRegion, bool) {
	region, ok := ext.byID[id]
	return region, ok
}
