package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type RouteByID struct {
	byID map[int32]*rasp.TRoute
}

func NewRouteByID() *RouteByID {
	return &RouteByID{
		byID: make(map[int32]*rasp.TRoute),
	}
}

func (ext *RouteByID) AddProto(message proto.Message) {
	route := message.(*rasp.TRoute)
	if route.Id != 0 {
		ext.byID[route.Id] = route
	}
}

func (ext *RouteByID) Get(id int32) (*rasp.TRoute, bool) {
	route, ok := ext.byID[id]
	return route, ok
}

func (ext *RouteByID) All() []*rasp.TRoute {
	result := make([]*rasp.TRoute, 0, len(ext.byID))
	for _, route := range ext.byID {
		result = append(result, route)
	}
	return result
}
