package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type SettlementByID struct {
	byID map[int32]*rasp.TSettlement
}

func NewSettlementByID() *SettlementByID {
	return &SettlementByID{
		byID: make(map[int32]*rasp.TSettlement),
	}
}

func (ext *SettlementByID) AddProto(message proto.Message) {
	settlement := message.(*rasp.TSettlement)
	if settlement.GetId() != 0 {
		ext.byID[settlement.Id] = settlement
	}
}

func (ext *SettlementByID) Get(id int32) (*rasp.TSettlement, bool) {
	settlement, ok := ext.byID[id]
	return settlement, ok
}

type SettlementByGeoID struct {
	byGeoID map[int32]*rasp.TSettlement
}

func NewSettlementByGeoID() *SettlementByGeoID {
	return &SettlementByGeoID{
		byGeoID: make(map[int32]*rasp.TSettlement),
	}
}

func (ext *SettlementByGeoID) AddProto(message proto.Message) {
	settlement := message.(*rasp.TSettlement)
	if settlement.GetGeoId() != 0 {
		ext.byGeoID[settlement.GeoId] = settlement
	}
}

func (ext *SettlementByGeoID) GetByGeoID(geoID int32) (*rasp.TSettlement, bool) {
	settlement, ok := ext.byGeoID[geoID]
	return settlement, ok
}

type SettlementBySlug struct {
	bySlug map[string]*rasp.TSettlement
}

func NewSettlementBySlug() *SettlementBySlug {
	return &SettlementBySlug{
		bySlug: make(map[string]*rasp.TSettlement),
	}
}

func (ext *SettlementBySlug) AddProto(message proto.Message) {
	settlement := message.(*rasp.TSettlement)
	if settlement.Slug != "" {
		ext.bySlug[settlement.Slug] = settlement
	}
}

func (ext *SettlementBySlug) GetBySlug(slug string) (*rasp.TSettlement, bool) {
	settlement, ok := ext.bySlug[slug]
	return settlement, ok
}

type SettlementsByCountryID struct {
	byCountryID map[int][]*rasp.TSettlement
}

func NewSettlementsByCountryID() *SettlementsByCountryID {
	return &SettlementsByCountryID{
		byCountryID: make(map[int][]*rasp.TSettlement),
	}
}

func (ext *SettlementsByCountryID) AddProto(message proto.Message) {
	settlement := message.(*rasp.TSettlement)
	if id := int(settlement.GetCountryId()); id != 0 {
		ext.byCountryID[id] = append(ext.byCountryID[id], settlement)
	}
}

func (ext *SettlementsByCountryID) GetByCountryID(countryID int) []*rasp.TSettlement {
	return ext.byCountryID[countryID]
}
