package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationByID struct {
	byID map[int32]*rasp.TStation
}

func NewStationByID() *StationByID {
	return &StationByID{
		byID: make(map[int32]*rasp.TStation),
	}
}

func (ext *StationByID) AddProto(message proto.Message) {
	station := message.(*rasp.TStation)
	if station.Id != 0 {
		ext.byID[station.Id] = station
	}
}

func (ext *StationByID) Get(id int32) (*rasp.TStation, bool) {
	station, ok := ext.byID[id]
	return station, ok
}

func (ext *StationByID) All() []*rasp.TStation {
	result := make([]*rasp.TStation, 0, len(ext.byID))
	for _, station := range ext.byID {
		result = append(result, station)
	}
	return result
}

type StationBySettlement struct {
	stationsBySettlement map[int32][]*rasp.TStation
}

func NewStationBySettlement() *StationBySettlement {
	return &StationBySettlement{
		stationsBySettlement: make(map[int32][]*rasp.TStation),
	}
}

func (ext *StationBySettlement) AddProto(message proto.Message) {
	station := message.(*rasp.TStation)
	settlementID := station.GetSettlementId()
	if settlementID != 0 {
		ext.stationsBySettlement[settlementID] = append(ext.stationsBySettlement[settlementID], station)
	}
}

func (ext *StationBySettlement) GetBySettlementID(id int32) ([]*rasp.TStation, bool) {
	settlement, ok := ext.stationsBySettlement[id]
	return settlement, ok
}

type StationBySlug struct {
	bySlug map[string]*rasp.TStation
}

func NewStationBySlug() *StationBySlug {
	return &StationBySlug{
		bySlug: make(map[string]*rasp.TStation),
	}
}

func (ext *StationBySlug) AddProto(message proto.Message) {
	station := message.(*rasp.TStation)
	if station.Slug != "" {
		ext.bySlug[station.Slug] = station
	}
}

func (ext *StationBySlug) GetBySlug(slug string) (*rasp.TStation, bool) {
	station, ok := ext.bySlug[slug]
	return station, ok
}
