package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationCodesByStationID struct {
	byStationID map[int32][]*rasp.TStationCode
}

func NewStationCodesByStationID() *StationCodesByStationID {
	return &StationCodesByStationID{
		byStationID: make(map[int32][]*rasp.TStationCode),
	}
}

func (ext *StationCodesByStationID) AddProto(message proto.Message) {
	stationCode := message.(*rasp.TStationCode)
	if stationCode.StationId != 0 {
		ext.byStationID[stationCode.StationId] = append(
			ext.byStationID[stationCode.StationId],
			stationCode,
		)
	}
}

func (ext *StationCodesByStationID) GetCodesByStationID(id int32) ([]*rasp.TStationCode, bool) {
	stationCodes, ok := ext.byStationID[id]
	return stationCodes, ok
}

type StationCodesBySystemID struct {
	index map[rasp.ECodeSystem][]*rasp.TStationCode
}

func NewStationCodesBySystemID() *StationCodesBySystemID {
	return &StationCodesBySystemID{
		index: make(map[rasp.ECodeSystem][]*rasp.TStationCode),
	}
}

func (ext *StationCodesBySystemID) AddProto(message proto.Message) {
	stationCode, ok := message.(*rasp.TStationCode)
	if !ok {
		return
	}

	if stationCode.StationId != 0 {
		ext.index[stationCode.SystemId] = append(
			ext.index[stationCode.SystemId],
			stationCode,
		)
	}
}

func (ext *StationCodesBySystemID) GetCodesBySystemID(systemID rasp.ECodeSystem) []*rasp.TStationCode {
	return ext.index[systemID]
}
