package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type ThreadByID struct {
	byID map[int32]*rasp.TThread
}

func NewThreadByID() *ThreadByID {
	return &ThreadByID{
		byID: make(map[int32]*rasp.TThread),
	}
}

func (ext *ThreadByID) AddProto(message proto.Message) {
	thread := message.(*rasp.TThread)
	if thread.Id != 0 {
		ext.byID[thread.Id] = thread
	}
}

func (ext *ThreadByID) Get(id int32) (*rasp.TThread, bool) {
	thread, ok := ext.byID[id]
	return thread, ok
}

func (ext *ThreadByID) All() []*rasp.TThread {
	result := make([]*rasp.TThread, 0, len(ext.byID))
	for _, thread := range ext.byID {
		result = append(result, thread)
	}
	return result
}
