package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type ThreadStationByID struct {
	byID map[int32]*rasp.TThreadStation
}

func NewThreadStationByID() *ThreadStationByID {
	return &ThreadStationByID{
		byID: make(map[int32]*rasp.TThreadStation),
	}
}

func (ext *ThreadStationByID) AddProto(message proto.Message) {
	threadStation := message.(*rasp.TThreadStation)
	if threadStation.Id != 0 {
		ext.byID[threadStation.Id] = threadStation
	}
}

func (ext *ThreadStationByID) Get(id int32) (*rasp.TThreadStation, bool) {
	threadStation, ok := ext.byID[id]
	return threadStation, ok
}

func (ext *ThreadStationByID) All() []*rasp.TThreadStation {
	result := make([]*rasp.TThreadStation, 0, len(ext.byID))
	for _, threadStation := range ext.byID {
		result = append(result, threadStation)
	}
	return result
}

type ThreadStationByThreadID struct {
	byThreadID map[int32][]*rasp.TThreadStation
}

func NewThreadStationByThreadID() *ThreadStationByThreadID {
	return &ThreadStationByThreadID{
		byThreadID: make(map[int32][]*rasp.TThreadStation),
	}
}

func (ext *ThreadStationByThreadID) AddProto(message proto.Message) {
	threadStation := message.(*rasp.TThreadStation)
	if threadStation.ThreadId != 0 {
		ext.byThreadID[threadStation.ThreadId] = append(
			ext.byThreadID[threadStation.ThreadId],
			threadStation,
		)
	}
}

func (ext *ThreadStationByThreadID) GetByThreadStationID(threadID int32) []*rasp.TThreadStation {
	return ext.byThreadID[threadID]
}
