package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type TimeZoneByID struct {
	byID   map[int32]*rasp.TTimeZone
	byCode map[string]*rasp.TTimeZone
}

func NewTimeZoneByID() *TimeZoneByID {
	return &TimeZoneByID{
		byID:   make(map[int32]*rasp.TTimeZone),
		byCode: make(map[string]*rasp.TTimeZone),
	}
}

func (ext *TimeZoneByID) AddProto(message proto.Message) {
	if zone, ok := message.(*rasp.TTimeZone); ok {
		ext.byID[zone.Id] = zone
		ext.byCode[zone.Code] = zone
	}
}

func (ext *TimeZoneByID) Get(id int32) (*rasp.TTimeZone, bool) {
	zone, ok := ext.byID[id]
	return zone, ok
}

func (ext *TimeZoneByID) GetByCode(code string) (*rasp.TTimeZone, bool) {
	zone, ok := ext.byCode[code]
	return zone, ok
}

func (ext *TimeZoneByID) All() []*rasp.TTimeZone {
	result := make([]*rasp.TTimeZone, 0, len(ext.byID))
	for _, zone := range ext.byID {
		result = append(result, zone)
	}
	return result
}
