package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/avia"
)

type SettlementRepository struct {
	settlements map[int64]*avia.TSettlement
}

func NewSettlementRepository() *SettlementRepository {
	return &SettlementRepository{
		settlements: make(map[int64]*avia.TSettlement),
	}
}

func (sr *SettlementRepository) DeserializeRow(row []byte) (*avia.TSettlement, error) {
	settlement := &avia.TSettlement{}
	if err := proto.Unmarshal(row, settlement); err != nil {
		return nil, fmt.Errorf("SettlementRepository:Write: %w", err)
	}
	return settlement, nil
}

func (sr *SettlementRepository) Write(b []byte) (int, error) {
	settlement, err := sr.DeserializeRow(b)
	if err != nil {
		return 0, err
	}
	sr.settlements[settlement.Id] = settlement
	return len(b), nil
}

func (sr *SettlementRepository) Get(id int) (*avia.TSettlement, bool) {
	settlement, ok := sr.settlements[int64(id)]
	return settlement, ok
}
