package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/avia"
)

type StationRepository struct {
	stations map[int]*avia.TStation
}

func NewStationRepository() *StationRepository {
	return &StationRepository{
		stations: make(map[int]*avia.TStation),
	}
}

func (sr *StationRepository) DeserializeRow(row []byte) (*avia.TStation, error) {
	station := &avia.TStation{}
	if err := proto.Unmarshal(row, station); err != nil {
		return nil, fmt.Errorf("StationRepository:DeserializeRow: %w", err)
	}
	return station, nil
}

func (sr *StationRepository) Write(b []byte) (int, error) {
	if station, err := sr.DeserializeRow(b); err != nil {
		return 0, err
	} else {
		sr.Add(station)
		return len(b), nil
	}
}

func (sr *StationRepository) Get(id int) (*avia.TStation, bool) {
	station, ok := sr.stations[id]
	return station, ok
}

func (sr *StationRepository) Add(station *avia.TStation) {
	sr.stations[int(station.Id)] = station
}
