package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/avia"
)

type StationCodeRepository struct {
	stationCodes map[int32]*avia.TStationCode
}

func NewStationCodeRepository() *StationCodeRepository {
	return &StationCodeRepository{
		stationCodes: make(map[int32]*avia.TStationCode)}
}

func (cr *StationCodeRepository) Write(b []byte) (int, error) {
	stationCode := &avia.TStationCode{}
	if err := proto.Unmarshal(b, stationCode); err != nil {
		return 0, fmt.Errorf("StationCodeRepository:Write: %w", err)
	}
	cr.stationCodes[stationCode.StationId] = stationCode
	return len(b), nil
}

func (cr *StationCodeRepository) Get(id int) (*avia.TStationCode, bool) {
	stationCode, ok := cr.stationCodes[int32(id)]
	return stationCode, ok
}
