package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/avia"
)

type Station2SettlementRepository struct {
	station2Settlements map[int32]*avia.TStation2Settlement
}

func NewStation2SettlementRepository() *Station2SettlementRepository {
	return &Station2SettlementRepository{
		station2Settlements: make(map[int32]*avia.TStation2Settlement)}
}

func (cr *Station2SettlementRepository) Write(b []byte) (int, error) {
	station2Settlement := &avia.TStation2Settlement{}
	if err := proto.Unmarshal(b, station2Settlement); err != nil {
		return 0, fmt.Errorf("Station2SettlementRepository:Write: %w", err)
	}
	cr.station2Settlements[station2Settlement.StationId] = station2Settlement
	return len(b), nil
}

func (cr *Station2SettlementRepository) Get(id int) (*avia.TStation2Settlement, bool) {
	station2Settlement, ok := cr.station2Settlements[int32(id)]
	return station2Settlement, ok
}
