package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type CarrierRepository struct {
	carriers map[int32]*rasp.TCarrier
}

func NewCarrierRepository() *CarrierRepository {
	return &CarrierRepository{
		carriers: make(map[int32]*rasp.TCarrier)}
}

func (cr *CarrierRepository) Add(message proto.Message) {
	carrier := message.(*rasp.TCarrier)
	cr.carriers[carrier.Id] = carrier
}

func (cr *CarrierRepository) Write(b []byte) (int, error) {
	carrier := &rasp.TCarrier{}
	if err := proto.Unmarshal(b, carrier); err != nil {
		return 0, fmt.Errorf("CarrierRepository:Write: %w", err)
	}
	cr.carriers[carrier.Id] = carrier
	return len(b), nil
}

func (cr *CarrierRepository) Get(id int) (*rasp.TCarrier, bool) {
	carrier, ok := cr.carriers[int32(id)]
	return carrier, ok
}
