package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type CountryRepository struct {
	countries map[int32]*rasp.TCountry
}

func NewCountryRepository() *CountryRepository {
	return &CountryRepository{
		countries: make(map[int32]*rasp.TCountry),
	}
}

func (cr *CountryRepository) Add(message proto.Message) {
	country := message.(*rasp.TCountry)
	cr.countries[country.Id] = country
}

func (cr *CountryRepository) Write(b []byte) (int, error) {
	country := &rasp.TCountry{}
	if err := proto.Unmarshal(b, country); err != nil {
		return 0, fmt.Errorf("CountryRepository:Write: %w", err)
	}
	cr.Add(country)
	return len(b), nil
}

func (cr *CountryRepository) Get(id int32) (*rasp.TCountry, bool) {
	country, ok := cr.countries[id]
	return country, ok
}

func (cr *CountryRepository) DeserializeRow(row []byte) (*rasp.TCountry, error) {
	country := &rasp.TCountry{}
	if err := proto.Unmarshal(row, country); err != nil {
		return nil, fmt.Errorf("CountryRepository:DeserializeRow: %w", err)
	}
	return country, nil
}
