package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type CurrencyRepository struct {
	currencies map[int32]*rasp.TCurrency
}

func NewCurrencyRepository() *CurrencyRepository {
	return &CurrencyRepository{
		currencies: make(map[int32]*rasp.TCurrency)}
}

func (cr *CurrencyRepository) Add(message proto.Message) {
	currency := message.(*rasp.TCurrency)
	cr.currencies[currency.Id] = currency
}

func (cr *CurrencyRepository) Write(b []byte) (int, error) {
	currency := &rasp.TCurrency{}
	if err := proto.Unmarshal(b, currency); err != nil {
		return 0, fmt.Errorf("CurrencyRepository:Write: %w", err)
	}
	cr.Add(currency)
	return len(b), nil
}

func (cr *CurrencyRepository) Get(id int) (*rasp.TCurrency, bool) {
	currency, ok := cr.currencies[int32(id)]
	return currency, ok
}
