package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type DistrictRepository struct {
	districts map[uint32]*rasp.TDistrict
}

func NewDistrictRepository() *DistrictRepository {
	return &DistrictRepository{
		districts: make(map[uint32]*rasp.TDistrict)}
}

func (cr *DistrictRepository) Write(b []byte) (int, error) {
	district := &rasp.TDistrict{}
	if err := proto.Unmarshal(b, district); err != nil {
		return 0, fmt.Errorf("DistrictRepository:Write: %w", err)
	}
	cr.districts[district.Id] = district
	return len(b), nil
}

func (cr *DistrictRepository) Get(id int) (*rasp.TDistrict, bool) {
	district, ok := cr.districts[uint32(id)]
	return district, ok
}
