package extensions

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type SettlementByID struct {
	byID map[int32]*rasp.TSettlement
}

func NewSettlementByID() *SettlementByID {
	return &SettlementByID{
		byID: make(map[int32]*rasp.TSettlement),
	}
}

func (ext *SettlementByID) AddProto(message proto.Message) {
	settlement := message.(*rasp.TSettlement)
	if settlement.Id != 0 {
		ext.byID[settlement.Id] = settlement
	}
}

func (ext *SettlementByID) Get(id int) (*rasp.TSettlement, bool) {
	settlement, ok := ext.byID[int32(id)]
	return settlement, ok
}

type SettlementByGeoID struct {
	byGeoID map[int32]*rasp.TSettlement
}

func NewSettlementByGeoID() *SettlementByGeoID {
	return &SettlementByGeoID{
		byGeoID: make(map[int32]*rasp.TSettlement),
	}
}

func (ext *SettlementByGeoID) AddProto(message proto.Message) {
	settlement := message.(*rasp.TSettlement)
	if settlement.GeoId != 0 {
		ext.byGeoID[settlement.GeoId] = settlement
	}
}

func (ext *SettlementByGeoID) GetByGeoID(geoID int) (*rasp.TSettlement, bool) {
	settlement, ok := ext.byGeoID[int32(geoID)]
	return settlement, ok
}
