package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type RegionRepository struct {
	regions map[uint32]*rasp.TRegion
}

func NewRegionRepository() *RegionRepository {
	return &RegionRepository{
		regions: make(map[uint32]*rasp.TRegion)}
}

func (cr *RegionRepository) Add(message proto.Message) {
	region := message.(*rasp.TRegion)
	cr.regions[region.Id] = region
}

func (cr *RegionRepository) Write(b []byte) (int, error) {
	region := &rasp.TRegion{}
	if err := proto.Unmarshal(b, region); err != nil {
		return 0, fmt.Errorf("RegionRepository:Write: %w", err)
	}
	cr.Add(region)
	return len(b), nil
}

func (cr *RegionRepository) Get(id int) (*rasp.TRegion, bool) {
	region, ok := cr.regions[uint32(id)]
	return region, ok
}
