package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type SettlementRepository struct {
	settlements map[int32]*rasp.TSettlement
}

func NewSettlementRepository() *SettlementRepository {
	return &SettlementRepository{
		settlements: make(map[int32]*rasp.TSettlement),
	}
}

func (cr *SettlementRepository) Add(message proto.Message) {
	settlement := message.(*rasp.TSettlement)
	cr.settlements[settlement.Id] = settlement
}

func (cr *SettlementRepository) Write(b []byte) (int, error) {
	settlement := &rasp.TSettlement{}
	if err := proto.Unmarshal(b, settlement); err != nil {
		return 0, fmt.Errorf("SettlementRepository:Write: %w", err)
	}
	cr.Add(settlement)
	return len(b), nil
}

func (cr *SettlementRepository) Get(id int) (*rasp.TSettlement, bool) {
	settlement, ok := cr.settlements[int32(id)]
	return settlement, ok
}

func (cr *SettlementRepository) DeserializeRow(row []byte) (*rasp.TSettlement, error) {
	settlement := &rasp.TSettlement{}
	if err := proto.Unmarshal(row, settlement); err != nil {
		return nil, fmt.Errorf("SettlementRepository:Write: %w", err)
	}
	return settlement, nil
}
