package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationRepository struct {
	stations map[int]*rasp.TStation
}

func NewStationRepository() *StationRepository {
	return &StationRepository{
		stations: make(map[int]*rasp.TStation)}
}

func (cr *StationRepository) Add(message proto.Message) {
	station := message.(*rasp.TStation)
	cr.stations[int(station.Id)] = station
}

func (cr *StationRepository) Write(b []byte) (int, error) {
	station := &rasp.TStation{}
	if err := proto.Unmarshal(b, station); err != nil {
		return 0, fmt.Errorf("StationRepository:Write: %w", err)
	}
	cr.Add(station)
	return len(b), nil
}

func (cr *StationRepository) Get(id int) (*rasp.TStation, bool) {
	station, ok := cr.stations[id]
	return station, ok
}

func (cr *StationRepository) DeserializeRow(row []byte) (*rasp.TStation, error) {
	station := &rasp.TStation{}
	if err := proto.Unmarshal(row, station); err != nil {
		return nil, fmt.Errorf("StationRepository:DeserializeRow: %w", err)
	}
	return station, nil
}
