package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationCodeRepository struct {
	stationCodes map[int32]*rasp.TStationCode
}

func NewStationCodeRepository() *StationCodeRepository {
	return &StationCodeRepository{
		stationCodes: make(map[int32]*rasp.TStationCode)}
}

func (cr *StationCodeRepository) Add(message proto.Message) {
	stationCode := message.(*rasp.TStationCode)
	cr.stationCodes[stationCode.StationId] = stationCode
}

func (cr *StationCodeRepository) Write(b []byte) (int, error) {
	stationCode := &rasp.TStationCode{}
	if err := proto.Unmarshal(b, stationCode); err != nil {
		return 0, fmt.Errorf("StationCodeRepository:Write: %w", err)
	}
	cr.Add(stationCode)
	return len(b), nil
}

func (cr *StationCodeRepository) Get(id int) (*rasp.TStationCode, bool) {
	stationCode, ok := cr.stationCodes[int32(id)]
	return stationCode, ok
}

func (cr *StationCodeRepository) DeserializeRow(row []byte) (*rasp.TStationCode, error) {
	code := &rasp.TStationCode{}
	if err := proto.Unmarshal(row, code); err != nil {
		return nil, fmt.Errorf("StationCodeRepository:DeserializeRow: %w", err)
	}
	return code, nil
}
