package repository

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationExpressAliasRepository struct {
	stationExpressAlias map[string]*rasp.TStationExpressAlias
}

func NewStationExpressAliasRepository() *StationExpressAliasRepository {
	return &StationExpressAliasRepository{
		stationExpressAlias: make(map[string]*rasp.TStationExpressAlias)}
}

func (cr *StationExpressAliasRepository) Add(message proto.Message) {
	stationExpressAlias := message.(*rasp.TStationExpressAlias)
	cr.stationExpressAlias[stationExpressAlias.Alias] = stationExpressAlias
}

func (cr *StationExpressAliasRepository) Write(b []byte) (int, error) {
	const funcName = "StationExpressAliasRepository:Write"
	stationExpressAlias := &rasp.TStationExpressAlias{}
	if err := proto.Unmarshal(b, stationExpressAlias); err != nil {
		return 0, fmt.Errorf("%s: %w", funcName, err)
	}
	cr.Add(stationExpressAlias)
	return len(b), nil
}

func (cr *StationExpressAliasRepository) Get(alias string) (*rasp.TStationExpressAlias, bool) {
	stationExpressAlias, ok := cr.stationExpressAlias[alias]
	return stationExpressAlias, ok
}

func (cr *StationExpressAliasRepository) DeserializeRow(row []byte) (*rasp.TStationExpressAlias, error) {
	stationExpressAlias := &rasp.TStationExpressAlias{}
	if err := proto.Unmarshal(row, stationExpressAlias); err != nil {
		return nil, fmt.Errorf("StationExpressAliasRepository:DeserializeRow: %w", err)
	}
	return stationExpressAlias, nil
}
